/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.world.inventory;

import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.util.PagingDirection;
import io.github.mortuusars.exposure.util.Side;
import io.github.mortuusars.exposure.world.item.AlbumItem;
import io.github.mortuusars.exposure.world.item.SignedAlbumItem;
import io.github.mortuusars.exposure.world.item.component.album.SignedAlbumPage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_3915;
import net.minecraft.class_3917;
import net.minecraft.class_9129;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SignedAlbumMenu
extends class_1703 {
    public static final int PREVIOUS_PAGE_BUTTON = PagingDirection.PREVIOUS.ordinal();
    public static final int NEXT_PAGE_BUTTON = PagingDirection.NEXT.ordinal();
    protected final int albumSlot;
    protected final class_1799 albumStack;
    protected final SignedAlbumItem albumItem;
    protected class_3915 currentSpreadIndex = class_3915.method_17403();
    protected final Map<Integer, Consumer<class_1657>> buttonActions = new HashMap<Integer, Consumer<class_1657>>(){
        {
            this.put(PREVIOUS_PAGE_BUTTON, p -> SignedAlbumMenu.this.setCurrentSpreadIndex(Math.max(0, SignedAlbumMenu.this.getCurrentSpreadIndex() - 1)));
            this.put(NEXT_PAGE_BUTTON, p -> SignedAlbumMenu.this.setCurrentSpreadIndex(Math.min((SignedAlbumMenu.this.getPages().size() - 1) / 2, SignedAlbumMenu.this.getCurrentSpreadIndex() + 1)));
        }
    };

    public SignedAlbumMenu(int containerId, class_1661 playerInventory, int albumSlot) {
        this(Exposure.MenuTypes.SIGNED_ALBUM.get(), containerId, playerInventory, albumSlot);
    }

    protected SignedAlbumMenu(class_3917<? extends class_1703> type, int containerId, class_1661 playerInventory, int albumSlot) {
        super(type, containerId);
        this.albumSlot = albumSlot;
        this.albumStack = playerInventory.method_5438(albumSlot);
        class_1792 class_17922 = this.albumStack.method_7909();
        if (!(class_17922 instanceof SignedAlbumItem)) {
            throw new IllegalStateException("Expected SignedAlbumItem in slot '" + albumSlot + "'. Got: " + String.valueOf(this.albumStack));
        }
        SignedAlbumItem item = (SignedAlbumItem)class_17922;
        this.albumItem = item;
        this.method_17362(this.currentSpreadIndex);
    }

    public int getAlbumSlot() {
        return this.albumSlot;
    }

    public List<SignedAlbumPage> getPages() {
        return this.albumItem.getContent(this.albumStack).pages();
    }

    public Optional<SignedAlbumPage> getPage(int pageIndex) {
        if (pageIndex <= this.getPages().size() - 1) {
            return Optional.ofNullable(this.getPages().get(pageIndex));
        }
        return Optional.empty();
    }

    public Optional<SignedAlbumPage> getPage(Side side) {
        return this.getPage(this.getCurrentSpreadIndex() * 2 + side.getIndex());
    }

    public class_1799 getPhotograph(Side side) {
        return this.getPage(side).orElse(SignedAlbumPage.EMPTY).photograph();
    }

    public int getCurrentSpreadIndex() {
        return this.currentSpreadIndex.method_17407();
    }

    public void setCurrentSpreadIndex(int spreadIndex) {
        this.currentSpreadIndex.method_17404(spreadIndex);
    }

    public boolean method_7604(class_1657 player, int id) {
        @Nullable Consumer<class_1657> buttonAction = this.buttonActions.get(id);
        if (buttonAction != null) {
            buttonAction.accept(player);
            return true;
        }
        return false;
    }

    @NotNull
    public class_1799 method_7601(class_1657 player, int index) {
        return class_1799.field_8037;
    }

    public boolean method_7597(class_1657 player) {
        return player.method_31548().method_5438(this.albumSlot).method_7909() instanceof AlbumItem;
    }

    public static SignedAlbumMenu fromBuffer(int containerId, class_1661 playerInventory, class_9129 buffer) {
        return new SignedAlbumMenu(containerId, playerInventory, buffer.method_10816());
    }
}

